<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lead extends Eloquent {

	protected $table = 'leads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('status');

	public function getHistory()
	{
		return $this->hasMany('App\History');
	}

	public function creator()
	{
		return $this->belongsTo('App\User');
	}

	public function sharedTo()
	{
		return $this->belongsToMany('App\User');
	}

}