<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHistoryTable extends Migration {

	public function up()
	{
		Schema::create('history', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('lead_id')->unsigned();
			$table->json('metadata')->default('[]');
			$table->string('type');
			$table->enum('status', array('public', 'peer_to_peer', 'group_only', 'private'));
			$table->integer('created_by')->unsigned()->nullable();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('history');
	}
}