<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionsTable extends Migration {

	public function up()
	{
		Schema::create('subscriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('institution_id')->unsigned();
			$table->string('name')->nullable();
			$table->json('metadata')->default('[]');
			$table->timestamps();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('subscriptions');
	}
}