<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid', 40)->unique();
			$table->string('username', 50)->unique();
			$table->string('phone', 11)->unique()->nullable();
			$table->string('email')->unique();
			$table->string('password');
			$table->string('name')->nullable();
			$table->string('last_name')->nullable();
			$table->enum('status', array('created', 'related', 'active', 'disabled', 'deleted'));
			$table->json('metadata')->nullable();
			$table->timestamps();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}