<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonnelTable extends Migration {

	public function up()
	{
		Schema::create('personnel', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('nom')->nullable();
			$table->string('prenom')->nullable();
			$table->string('telephone')->nullable();
			$table->string('email')->unique()->nullable();
			$table->enum('sexe', array('homme', 'femme'))->nullable();
			$table->string('pv_prestation')->nullable();
			$table->string('arrete_nomination')->nullable();
			$table->integer('age')->default('0');
			$table->string('date_prise_fonction')->nullable();
			$table->integer('type_personnel_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('personnel');
	}
}