<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('customer_id')->nullable();
			$table->tinyInteger('delivery_option')->nullable();
			$table->decimal('total', 10,2)->default('0');
			$table->tinyInteger('status')->nullable();
			$table->bigInteger('shipping_address_id')->nullable();
			$table->bigInteger('branch_id')->nullable();
			$table->tinyInteger('is_open')->default('0');
			$table->tinyInteger('is_new')->default('0');
			$table->bigInteger('assigned_to_agent_id')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}