<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('date');
			$table->integer('transaction_item_id');
			$table->integer('safe_id');
			$table->text('notes');
			$table->tinyInteger('type');
			$table->float('amount', 10,2);
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}