<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChildrensTable extends Migration {

	public function up()
	{
		Schema::create('childrens', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->enum('gender', array('male', 'female'));
			$table->datetime('birth_date');
			$table->bigInteger('employee_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('childrens');
	}
}