<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class JobHistory extends Eloquent {

	protected $table = 'job_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('date', 'employee_id', 'job_function_id', 'financial_degree_id', 'degree_date', 'job_style_id', 'cadre', 'job_status', 'nomination_type_id');

	public function job_functions()
	{
		return $this->belongsTo('JobFunction');
	}

	public function financial_degree()
	{
		return $this->belongsTo('FinancialDegree');
	}

	public function job_style()
	{
		return $this->belongsTo('JobStyle');
	}

	public function nomination_types()
	{
		return $this->belongsTo('NominationType');
	}

}