<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLanguagesTable extends Migration {

	public function up()
	{
		Schema::create('languages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->enum('level', array('Beginner', 'Intermediate', 'Proficient', 'Fluent', 'Native'));
			$table->bigInteger('employee_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('languages');
	}
}