<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Booking extends Model 
{

    protected $table = 'bookings';
    public $timestamps = true;
    protected $fillable = array('user_id', 'trip_id', 'status');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function trip()
    {
        return $this->belongsTo('Trip');
    }

    public function routes()
    {
        return $this->belongsToMany('Route');
    }

}