<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('faqs', function(Blueprint $table) {
			$table->foreign('faq_category_id')->references('id')->on('faq_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_roles', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_permissions', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_permissions', function(Blueprint $table) {
			$table->foreign('country_role_id')->references('id')->on('country_roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_admins', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_admins', function(Blueprint $table) {
			$table->foreign('country_role_id')->references('id')->on('country_roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('banners', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('discount_opportunities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('brands', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('badge_id')->references('id')->on('badges')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_reviews', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_tags', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_tags', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sub_category_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sub_category_product', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('sub_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('size_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('size_product', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('sizes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('excluded_coupon_countries', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('excluded_coupon_countries', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coupon_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('coupon_product', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('welcome_messages', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('excluded_product_countries', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('excluded_product_countries', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_points', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_points', function(Blueprint $table) {
			$table->foreign('point_type_id')->references('id')->on('point_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_banks', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_method_country', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payment_method_country', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('faqs', function(Blueprint $table) {
			$table->dropForeign('faqs_faq_category_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_country_id_foreign');
		});
		Schema::table('country_roles', function(Blueprint $table) {
			$table->dropForeign('country_roles_country_id_foreign');
		});
		Schema::table('country_permissions', function(Blueprint $table) {
			$table->dropForeign('country_permissions_country_id_foreign');
		});
		Schema::table('country_permissions', function(Blueprint $table) {
			$table->dropForeign('country_permissions_country_role_id_foreign');
		});
		Schema::table('country_admins', function(Blueprint $table) {
			$table->dropForeign('country_admins_country_id_foreign');
		});
		Schema::table('country_admins', function(Blueprint $table) {
			$table->dropForeign('country_admins_country_role_id_foreign');
		});
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->dropForeign('sub_categories_category_id_foreign');
		});
		Schema::table('banners', function(Blueprint $table) {
			$table->dropForeign('banners_country_id_foreign');
		});
		Schema::table('discount_opportunities', function(Blueprint $table) {
			$table->dropForeign('discount_opportunities_country_id_foreign');
		});
		Schema::table('brands', function(Blueprint $table) {
			$table->dropForeign('brands_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_brand_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_badge_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_coupon_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_country_id_foreign');
		});
		Schema::table('product_reviews', function(Blueprint $table) {
			$table->dropForeign('product_reviews_product_id_foreign');
		});
		Schema::table('product_reviews', function(Blueprint $table) {
			$table->dropForeign('product_reviews_user_id_foreign');
		});
		Schema::table('product_tags', function(Blueprint $table) {
			$table->dropForeign('product_tags_product_id_foreign');
		});
		Schema::table('product_tags', function(Blueprint $table) {
			$table->dropForeign('product_tags_tag_id_foreign');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->dropForeign('category_product_category_id_foreign');
		});
		Schema::table('category_product', function(Blueprint $table) {
			$table->dropForeign('category_product_product_id_foreign');
		});
		Schema::table('sub_category_product', function(Blueprint $table) {
			$table->dropForeign('sub_category_product_product_id_foreign');
		});
		Schema::table('sub_category_product', function(Blueprint $table) {
			$table->dropForeign('sub_category_product_sub_category_id_foreign');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->dropForeign('wishlists_product_id_foreign');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->dropForeign('wishlists_user_id_foreign');
		});
		Schema::table('product_images', function(Blueprint $table) {
			$table->dropForeign('product_images_product_id_foreign');
		});
		Schema::table('size_product', function(Blueprint $table) {
			$table->dropForeign('size_product_product_id_foreign');
		});
		Schema::table('size_product', function(Blueprint $table) {
			$table->dropForeign('size_product_size_id_foreign');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->dropForeign('coupons_country_id_foreign');
		});
		Schema::table('excluded_coupon_countries', function(Blueprint $table) {
			$table->dropForeign('excluded_coupon_countries_coupon_id_foreign');
		});
		Schema::table('excluded_coupon_countries', function(Blueprint $table) {
			$table->dropForeign('excluded_coupon_countries_country_id_foreign');
		});
		Schema::table('coupon_product', function(Blueprint $table) {
			$table->dropForeign('coupon_product_product_id_foreign');
		});
		Schema::table('coupon_product', function(Blueprint $table) {
			$table->dropForeign('coupon_product_coupon_id_foreign');
		});
		Schema::table('welcome_messages', function(Blueprint $table) {
			$table->dropForeign('welcome_messages_country_id_foreign');
		});
		Schema::table('excluded_product_countries', function(Blueprint $table) {
			$table->dropForeign('excluded_product_countries_product_id_foreign');
		});
		Schema::table('excluded_product_countries', function(Blueprint $table) {
			$table->dropForeign('excluded_product_countries_country_id_foreign');
		});
		Schema::table('user_points', function(Blueprint $table) {
			$table->dropForeign('user_points_user_id_foreign');
		});
		Schema::table('user_points', function(Blueprint $table) {
			$table->dropForeign('user_points_point_type_id_foreign');
		});
		Schema::table('country_banks', function(Blueprint $table) {
			$table->dropForeign('country_banks_country_id_foreign');
		});
		Schema::table('payment_method_country', function(Blueprint $table) {
			$table->dropForeign('payment_method_country_country_id_foreign');
		});
		Schema::table('payment_method_country', function(Blueprint $table) {
			$table->dropForeign('payment_method_country_payment_method_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_coupon_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_country_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_product_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_product_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_country_id_foreign');
		});
	}
}