<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Brand extends Eloquent {

	protected $table = 'brands';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'image', 'category_id');

	public function category()
	{
		return $this->belongsTo('Models\Category');
	}

	public function products()
	{
		return $this->hasMany('Models\Product');
	}

}