<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Brand extends Model 
{

    protected $table = 'brands';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'image', 'category_id');

    public function category()
    {
        return $this->belongsTo('Models\Category');
    }

    public function products()
    {
        return $this->hasMany('Models\Product');
    }

}