<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coupon extends Model 
{

    protected $table = 'coupons';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'offer_name', 'offer_details', 'end_at', 'add_to_offers', 'type', 'discount_type', 'free_shipping', 'get_free_product_count', 'usage_count', 'expire_date', 'count_usage_for_person', 'country_id');

    public function country()
    {
        return $this->belongsTo('Models\Country');
    }

    public function excludedCouponCountries()
    {
        return $this->hasMany('Models\ExcludedCouponCountry');
    }

    public function products()
    {
        return $this->belongsToMany('Models\Product');
    }

}