<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBannersTable extends Migration {

	public function up()
	{
		Schema::create('banners', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->bigInteger('country_id')->unsigned();
			$table->enum('type', array('image', 'video'));
		});
	}

	public function down()
	{
		Schema::drop('banners');
	}
}