<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartsTable extends Migration {

	public function up()
	{
		Schema::create('carts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->string('token', 191)->nullable();
			$table->bigInteger('product_id')->unsigned();
			$table->float('price');
			$table->float('discount')->nullable();
			$table->bigInteger('quantity');
			$table->bigInteger('country_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('carts');
	}
}