<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfficesTable extends Migration {

	public function up()
	{
		Schema::create('offices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->tinyInteger('is_main_office')->default('0');
			$table->tinyInteger('is_active')->default('0');
			$table->double('lat');
			$table->double('lng');
		});
	}

	public function down()
	{
		Schema::drop('offices');
	}
}