<?php

namespace \App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Advertiser extends Eloquent {

	protected $table = 'advertiser';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->hasMany('\App\Models\Product');
	}

	public function contact()
	{
		return $this->hasMany('App\Models\Advertiser\Contact2');
	}

}