<?php

namespace App\Models\Customer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Filiale extends Eloquent {

	protected $table = 'customer_filiale';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function service()
	{
		return $this->hasMany('App\Models\Customer\Service');
	}

	public function groupe()
	{
		return $this->belongsTo('App\Models\Customer\Groupe');
	}

}