<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function tasks()
    {
        return $this->morphedByMany('app\Categoryable');
    }

    public function products()
    {
        return $this->morphedByMany('app\Categoryable');
    }

    public function dictionaries()
    {
        return $this->morphedByMany('app\Categoryable');
    }

    public function media()
    {
        return $this->morphMany('app\Media');
    }

}