<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Orderitem extends Model 
{

    protected $table = 'orderitems';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product()
    {
        return $this->hasOne('app\Product');
    }

    public function order()
    {
        return $this->belongsTo('app\Order');
    }

}