<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Companies extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title');

	public function products()
	{
		return $this->hasMany('App\Products', 'id', 'wholesaler_id');
	}

}