<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MealPlanner extends Eloquent {

	protected $table = 'meal_planner';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('date', 'recipe_id', 'user_id');

	public function recipe()
	{
		return $this->hasOne('App\Recipes');
	}

	public function user()
	{
		return $this->hasOne('App\Users');
	}

}