<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Meats extends Eloquent {

	protected $table = 'meats';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'items_id');

	public function recipes()
	{
		return $this->hasManyThrough('App\Recipes', 'App\RecipeMeats', 'recipe_id', 'id', 'id', 'meats_id');
	}

	public function items()
	{
		return $this->belongsTo('App\Items', 'id', 'items_id');
	}

}