<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Products extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_hash', 'companies_id', 'name', 'package_unit_id', 'package_weight', 'price', 'price_unit_id', 'price_unit_cost', 'description', 'wholesalers_stockcode', 'is_on_special', 'is_in_stock', 'item_count', 'price_was', 'price_savings');

	public function package_unit()
	{
		return $this->hasOne('App\UnitMeasurements', 'id', 'package_unit_id');
	}

	public function items()
	{
		return $this->hasManyThrough('App\Items', 'App\ProductItems', 'items_id', 'id', 'id', 'product_id');
	}

	public function company()
	{
		return $this->belongsTo('App\Companies', 'id', 'companies_id');
	}

}