<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Recipes extends Eloquent {

	protected $table = 'recipes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_hash', 'title', 'description', 'servings', 'cooking_time', 'difficulty', 'prep_notes', 'instructions');

	public function recipe_ingredients()
	{
		return $this->hasMany('App\RecipeIngredients', 'recipe_id', 'id');
	}

	public function dressings()
	{
		return $this->hasManyThrough('App\Dressings', 'App\RecipeDressings', 'recipe_id', 'dressings_id', 'id', 'id');
	}

	public function meats()
	{
		return $this->hasManyThrough('App\Meats', 'App\RecipeMeats', 'recipe_id', 'meats_id', 'id', 'id');
	}

	public function sides()
	{
		return $this->hasManyThrough('App\Sides', 'App\RecipeSides', 'recipe_id', 'sides_id', 'id', 'id');
	}

	public function ingredients()
	{
		return $this->hasManyThrough('App\Ingredients', 'App\RecipeIngredients', 'recipe_id', 'ingredients_id', 'id', 'id');
	}

}