<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sides extends Eloquent {

	protected $table = 'sides';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'items_id');

	public function recipes()
	{
		return $this->hasManyThrough('App\Recipes', 'App\RecipeSides', 'recipe_id', 'id', 'id', 'sides_id');
	}

	public function items()
	{
		return $this->belongsTo('App\Items', 'id', 'items_id');
	}

}