<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('restaurant_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('restaurant_id')->unsigned();
			$table->string('locale', 255);
			$table->string('name', 255);
			$table->string('note_msg', 255);
			$table->text('info');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('restaurant_translations');
	}
}