<?php

namespace App\Restaurants;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function activations()
	{
		return $this->hasMany('RestaurantActivation');
	}

	public function payments()
	{
		return $this->hasMany('RestaurantPayment');
	}

	public function translations()
	{
		return $this->hasMany('RestaurantTranslation');
	}

}