<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDevicesTable extends Migration {

	public function up()
	{
		Schema::create('devices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('device_code', 50)->nullable();
			$table->string('mac', 30)->nullable();
			$table->string('cell_number', 20)->nullable();
			$table->string('manufacturer', 100)->nullable();
			$table->string('os', 50)->nullable();
			$table->string('version', 50)->nullable();
			$table->string('model', 100)->nullable();
			$table->string('imei', 255)->nullable();
			$table->string('app_version', 255)->nullable();
			$table->string('ip', 50)->nullable();
			$table->string('token', 100)->nullable();
			$table->string('previous_header_token', 100)->nullable();
			$table->integer('user_id')->nullable();
			$table->boolean('verified')->default(false);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('devices');
	}
}