<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Source extends Eloquent {

	protected $table = 'sources';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function categories()
	{
		return $this->belongsToMany('SourceCategory')sources_categories;
	}

	public function image()
	{
		return $this->hasOne('Image');
	}

	public function media()
	{
		return $this->hasOne('SourceMedia');
	}

}