<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TwitterKeyword extends Eloquent {

	protected $table = 'twitter_keywords';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contents()
	{
		return $this->hasMany('TwitterContent');
	}

	public function source()
	{
		return $this->belongsTo('Source');
	}

}