<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePoisTable extends Migration {

	public function up()
	{
		Schema::create('pois', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('name');
			$table->string('photo');
			$table->string('full_address');
			$table->string('city');
			$table->enum('status', array('published', 'unpublished', 'open', 'closed', 'temporary_closed', 'other'));
			$table->text('tickets');
			$table->json('icons')->default('{}');
			$table->string('caption_path');
			$table->string('latlng', 10);
			$table->text('description');
			$table->string('url');
			$table->bigInteger('category_id')->unsigned();
			$table->bigInteger('gallery_id')->unsigned();
			$table->string('beacon_uuid')->nullable();
			$table->json('i18n');
		});
	}

	public function down()
	{
		Schema::drop('pois');
	}
}