<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoutesTable extends Migration {

	public function up()
	{
		Schema::create('routes', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('title');
			$table->string('length');
			$table->string('duration');
			$table->text('description');
			$table->enum('status', array('published', 'unpublished'));
			$table->json('i18n');
		});
	}

	public function down()
	{
		Schema::drop('routes');
	}
}