<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSmOfferTable extends Migration {

	public function up()
	{
		Schema::create('sm_offer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('label', 255);
			$table->string('country', 255);
			$table->integer('sponsorOfferid');
			$table->integer('sponsor_id');
			$table->text('subjects');
			$table->text('froms');
			$table->integer('category_id');
			$table->float('payout');
			$table->string('payouttype', 45);
			$table->tinyInteger('hassuppFile');
			$table->string('suppFileStatus', 45);
			$table->string('optln', 45);
			$table->string('optOut', 45);
			$table->tinyInteger('status');
			$table->text('restrictions');
		});
	}

	public function down()
	{
		Schema::drop('sm_offer');
	}
}