<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Incidencia extends Model 
{

    protected $table = 'incidencias';
    public $timestamps = true;

    public function empleado()
    {
        return $this->belongsTo('App\Empleado', '"empresa_id"', '"empleado_id"');
    }

    public function calendario()
    {
        return $this->belongsTo('App\Calendarios', '"nomina_anio"', '"nomina_id"');
    }

    public function incidencia()
    {
        return $this->belongsTo('App\Falta', '"nomina_anio"', '"nomina_id"', '"empresa_id"', '"empleado_id"');
    }

}