<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function year_subject()
	{
		return $this->belongsTo('Yearsubject');
	}

	public function links()
	{
		return $this->hasMany('Link');
	}

}