<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Exercise extends Eloquent {

	protected $table = 'exercises';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function theme()
	{
		return $this->belongsTo('Theme');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function questionsanswers()
	{
		return $this->hasMany('Questionanswer');
	}

	public function multiplechoices()
	{
		return $this->hasMany('Multiplechoices');
	}

	public function textswithblanks()
	{
		return $this->hasMany('Textwithblanks');
	}

	public function tags()
	{
		return $this->belongsToMany('Tag');
	}

	public function medias()
	{
		return $this->belongsToMany('Media');
	}

	public function links()
	{
		return $this->belongsToMany('Link');
	}

	public function homeworks()
	{
		return $this->belongsToMany('Homework');
	}

}