<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function homeworks()
	{
		return $this->hasMany('Homework');
	}

	public function users()
	{
		return $this->belongsToMany('User');
	}

}