<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 255);
			$table->string('firstname', 255);
			$table->string('lastname', 255);
			$table->string('password', 255);
			$table->date('birthdate');
			$table->string('porfilePicture')->nullable();
			$table->string('country', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('level', 255);
			$table->string('access_token', 255)->unique();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}