<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormationsTable extends Migration {

	public function up()
	{
		Schema::create('formations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->string('desc', 255);
			$table->time('duration');
			$table->datetime('dateTime');
			$table->string('place', 255);
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id')->unsigned();
			$table->integer('formateur_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('formations');
	}
}