<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfitLogsTable extends Migration {

	public function up()
	{
		Schema::create('profit_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('coin_value', array('1', '5'));
			$table->string('comp_name', 255);
			$table->integer('user_id')->unsigned()->nullable()->index();
			$table->string('mac_address', 255);
		});
	}

	public function down()
	{
		Schema::drop('profit_logs');
	}
}