<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModelsTable extends Migration {

	public function up()
	{
		Schema::create('models', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->mediumInteger('root_id')->nullable();
			$table->string('name')->nullable();
			$table->mediumInteger('type_id')->nullable();
			$table->mediumInteger('purpose_id')->nullable();
			$table->double('size')->nullable();
			$table->string('size_measureme')->nullable();
			$table->mediumInteger('view_id')->nullable();
			$table->smallInteger('number_of_rooms');
			$table->smallInteger('bathrooms_number_from');
			$table->smallInteger('floor_number');
			$table->smallInteger('finishing');
			$table->tinyInteger('furnished')->default('0');
			$table->tinyInteger('ready_to_move')->default('0');
			$table->double('budget');
			$table->string('budget_measureme');
		});
	}

	public function down()
	{
		Schema::drop('models');
	}
}