<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Model extends Model 
{

    protected $table = 'models';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function root()
    {
        return $this->belongsTo('Root', 'root_id');
    }

    public function type()
    {
        return $this->belongsTo('Type', 'type_id');
    }

    public function purpose()
    {
        return $this->belongsTo('Purpose', 'purpose_id');
    }

    public function view()
    {
        return $this->belongsTo('View', 'view_id');
    }

}