<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ModelPropertie extends Model 
{

    protected $table = 'model_properties';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function model()
    {
        return $this->belongsTo('Model', 'model_id');
    }

    public function property()
    {
        return $this->belongsTo('Property', 'property_id');
    }

}