<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertySpecificationsTable extends Migration {

	public function up()
	{
		Schema::create('property_specifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('purchase_type', array('1', '2'));
			$table->enum('priority_level', array('1', '2', '3'));
			$table->enum('payment_method', array('1', '2'));
			$table->tinyInteger('now')->default('0');
			$table->datetime('received_date')->nullable();
			$table->string('area_of_interest')->nullable();
			$table->double('budget_from')->nullable();
			$table->double('budget_to')->nullable();
			$table->double('size_from')->nullable();
			$table->double('size_to')->nullable();
			$table->string('budget_measureme')->nullable();
			$table->string('size_measurement')->nullable();
			$table->mediumInteger('type_id');
			$table->integer('purpose_id')->nullable();
			$table->mediumInteger('view_id')->nullable();
			$table->tinyInteger('number_of_rooms')->nullable();
			$table->tinyInteger('bathrooms_number_from')->nullable();
			$table->tinyInteger('floor_number')->nullable();
			$table->smallInteger('finishing')->nullable();
			$table->tinyInteger('furnished')->default('0');
			$table->tinyInteger('ready_to_move')->default('0');
			$table->longText('note')->nullable();
			$table->mediumInteger('lead_id');
		});
	}

	public function down()
	{
		Schema::drop('property_specifications');
	}
}