<?php

namespace Models/MarketingChannel;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MarketingChannel extends Eloquent {

	protected $table = 'marketing_channels';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function leads()
	{
		return $this->belongsToMany('Lead', 'marketing_channel_id');
	}

}