<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ModelPropertie extends Eloquent {

	protected $table = 'model_properties';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function model()
	{
		return $this->belongsTo('Model', 'model_id');
	}

	public function property()
	{
		return $this->belongsTo('Property', 'property_id');
	}

}