<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Practice extends Model 
{

    protected $table = 'practices';
    public $timestamps = true;

    public function Driver()
    {
        return $this->hasMany('App\Driver');
    }

    public function Lap()
    {
        return $this->morphMany('App\Lap');
    }

    public function Race()
    {
        return $this->belongsTo('App\Event', 'race_id');
    }

    public function Result()
    {
        return $this->morphMany('App\Result');
    }

}